/*
 * kernel.c
 *
 *  Created on: May 3, 2010
 *      Author: cshkz6
 */
#define MODULE
#define __KERNEL__

#include <rtai.h>
#include <rtai_fifos.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <rtai_sched.h>

//globally defining ports
char *pbdr;
char *pbddr;

RT_TASK task;
void task_code(int input);
//creating string and first time stamp variable
struct data {
	int time1;
};

int init_module(void){
	int fifo2;

	//ioremap to new board
	pbdr=(char *)__ioremap(0x80840004,4096,0);
	pbddr=(char *)__ioremap(0x80840014,4096,0);

	//*pbdr = 0x01;
	*pbddr = 0x00;

	// create timer
	start_rt_timer(nano2count(10));

	//create fifos
	fifo2 = rtf_create(1,1000);

	//initialize real time task
	rt_task_init(&task, &task_code, 0, 4096, 0, 0, 0);

	rt_task_make_periodic(&task,rt_get_time(),nano2count(1000));

	return 0;
}

//task_code
void task_code(int input){
	struct data datastuff;
	while(1){
		datastuff.time1 = (unsigned int)*pbdr;
		rtf_put(1, &datastuff, sizeof(struct data));
		rt_task_wait_period();
	}
}

void cleanup_module(void){
	//deleting the task
	rt_task_delete(&task);

	//destroying the fifos
	rtf_destroy(1);

	//stopping the timer
	stop_rt_timer();
}
